<?php

namespace Config;

use CodeIgniter\Config\Filters as BaseFilters;
use CodeIgniter\Filters\Cors;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use CodeIgniter\Filters\ForceHTTPS;
use CodeIgniter\Filters\Honeypot;
use CodeIgniter\Filters\InvalidChars;
use CodeIgniter\Filters\PageCache;
use CodeIgniter\Filters\PerformanceMetrics;
use CodeIgniter\Filters\SecureHeaders;

// Shield filters (PAKAI YANG ADA DI vendor kamu)
use CodeIgniter\Shield\Filters\SessionAuth;
use CodeIgniter\Shield\Filters\GroupFilter;

class Filters extends BaseFilters
{
    public array $aliases = [
        'csrf'          => CSRF::class,
        'toolbar'       => DebugToolbar::class,
        'honeypot'      => Honeypot::class,
        'invalidchars'  => InvalidChars::class,
        'secureheaders' => SecureHeaders::class,
        'cors'          => Cors::class,
        'forcehttps'    => ForceHTTPS::class,
        'pagecache'     => PageCache::class,
        'performance'   => PerformanceMetrics::class,

        // ✅ Shield (INI YANG DIPAKAI)
        'sessionauth'   => SessionAuth::class,
        'group'         => GroupFilter::class,
    ];

    public array $required = [
        'before' => [
            // Kalau localhost, mending matikan dulu forcehttps
            // 'forcehttps',
            // 'pagecache',
        ],
        'after' => [
            'toolbar',
            // 'performance',
        ],
    ];

    public array $globals = [
        'before' => [
            // 'csrf',
        ],
        'after' => [
            // 'secureheaders',
        ],
    ];

    public array $methods = [];

    public array $filters = [];
}
